function [XPupil,YPupil,XImage,YImage] = get_coords(parameters)
% This function computes the xy-grids in pupil and image space.
%
% Sjoerd Stallinga, TU Delft

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

Npupil = parameters.Npupil;
Mx = parameters.Mx;
My = parameters.My;
NA = parameters.NA;
lambda = parameters.lambda;
ImageSizex = parameters.xrange;
ImageSizey = parameters.yrange;

% pupil radius (in diffraction units) and pupil coordinate sampling
PupilSize = 1.0;
% PupilSize = NA/lambda;
DxyPupil = 2*PupilSize/Npupil;
XYPupil = -PupilSize+DxyPupil/2:DxyPupil:PupilSize;
[YPupil,XPupil] = meshgrid(XYPupil,XYPupil);

% image coordinate sampling (in physical length units).
DxImage = 2*ImageSizex/Mx;
DyImage = 2*ImageSizey/My;
ximagelin = -ImageSizex+DxImage/2:DxImage:ImageSizex;
yimagelin = -ImageSizey+DyImage/2:DyImage:ImageSizey;
[YImage,XImage] = meshgrid(yimagelin,ximagelin);

end

